/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.access;

import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SignBlock;
import snownee.jade.addon.access.BlockAmountProvider;
import snownee.jade.addon.access.BlockDetailsBodyProvider;
import snownee.jade.addon.access.BlockDetailsProvider;
import snownee.jade.addon.access.EntityDetailsBodyProvider;
import snownee.jade.addon.access.EntityDetailsProvider;
import snownee.jade.addon.access.EntityVariantProvider;
import snownee.jade.addon.access.HeldItemProvider;
import snownee.jade.addon.access.SignProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.JadeIds;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.theme.IThemeHelper;

@WailaPlugin
public class AccessibilityPlugin
implements IWailaPlugin {
    @Override
    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent(new SignProvider(), SignBlock.class);
        registration.markAsClientFeature(JadeIds.ACCESS_SIGN);
        registration.registerBlockComponent(new BlockDetailsProvider(), Block.class);
        registration.registerBlockComponent(new BlockDetailsBodyProvider(), Block.class);
        registration.markAsClientFeature(JadeIds.ACCESS_BLOCK_DETAILS);
        registration.registerBlockComponent(new BlockAmountProvider(), Block.class);
        registration.markAsClientFeature(JadeIds.ACCESS_BLOCK_AMOUNT);
        registration.registerEntityComponent(new EntityDetailsProvider(), Entity.class);
        registration.registerEntityComponent(new EntityDetailsBodyProvider(), Entity.class);
        registration.markAsClientFeature(JadeIds.ACCESS_ENTITY_DETAILS);
        registration.registerEntityComponent(new EntityVariantProvider(), LivingEntity.class);
        registration.markAsClientFeature(JadeIds.ACCESS_ENTITY_VARIANT);
        registration.registerEntityComponent(new HeldItemProvider(), LivingEntity.class);
        registration.markAsClientFeature(JadeIds.ACCESS_HELD_ITEM);
    }

    public static void replaceTitle(ITooltip tooltip, String key) {
        String message = tooltip.getMessage(JadeIds.CORE_OBJECT_NAME);
        if (!message.isBlank()) {
            MutableComponent title = IThemeHelper.get().title(Component.translatable((String)("jade.access." + key), (Object[])new Object[]{message}));
            tooltip.replace(JadeIds.CORE_OBJECT_NAME, (Component)title);
        }
    }
}

